<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Jet Theme Backend for Magento 2 (System)
 */

namespace Amasty\JetTheme\Api\Data;

interface FooterLinkInterface
{
    public const TABLE_NAME = 'amasty_jet_footer_link';
    public const STORE_TABLE_NAME = 'amasty_jet_footer_link_store';

    public const ENTITY_ID = 'entity_id';
    public const TITLE = 'title';
    public const PATH = 'path';
    public const STATUS = 'status';
    public const SORT_ORDER = 'sort_order';
    public const STORES = 'stores';

    public const STORE_FOOTER_ID_FIELD = 'footer_link_id';
    public const STORE_FOOTER_STORE_ID_FIELD = 'store_id';

    public const STATUS_DISABLED = 0;
    public const STATUS_ENABLED = 1;

    /**
     * Get entity_id
     * @return int|string|null
     */
    public function getId();

    /**
     * Set entity_id
     * @param int|string $paymentLinkId
     * @return FooterLinkInterface
     */
    public function setId($paymentLinkId): FooterLinkInterface;

    /**
     * Get title
     * @return string|null
     */
    public function getTitle(): ?string;

    /**
     * Set title
     * @param string $title
     * @return FooterLinkInterface
     */
    public function setTitle(string $title): FooterLinkInterface;

    /**
     * Get title
     * @return string|null
     */
    public function getPath(): ?string;

    /**
     * Set title
     * @param string $path
     * @return FooterLinkInterface
     */
    public function setPath(string $path): FooterLinkInterface;

    /**
     * Get status
     * @return int|null
     */
    public function getStatus(): ?int;

    /**
     * Set status
     * @param int $status
     * @return FooterLinkInterface
     */
    public function setStatus(int $status): FooterLinkInterface;

    /**
     * Get sort_order
     * @return int|null
     */
    public function getSortOrder(): ?int;

    /**
     * Set sort_order
     * @param int $sortOrder
     * @return FooterLinkInterface
     */
    public function setSortOrder(int $sortOrder): FooterLinkInterface;

    /**
     * Get Stores
     * @return array|null
     */
    public function getStores(): ?array;

    /**
     * Set Stores
     * @param array $stores
     * @return FooterLinkInterface
     */
    public function setStores(array $stores): FooterLinkInterface;
}
