define([
    'jquery',
    'Magento_Ui/js/modal/confirm',
    'mage/translate'
], function ($, confirm, $t) {
    'use strict';

    $.widget('mage.delete_access_token', {
        options: {
            deleteButtonSelector: '.aminst-delete-access-token'
        },

        _create: function () {
            var self = this;

            $(document).on('click', this.options.deleteButtonSelector, function() {
                self.showConfirmationPopup();
            });
        },

        showConfirmationPopup: function () {
            var self = this;

            confirm({
                title: $t('Delete token'),
                content: $t('Are you sure you want to delete the token?'),
                actions: {
                    confirm: function () {
                        return $.ajax({
                            url: self.options.data.action_url,
                            data: {
                                store_id: self.options.data.store_id
                            }
                        }).always(function () {
                            location.reload();
                        });
                    }
                }
            });
        }
    });

    return $.mage.delete_access_token;
});
