define([
    'jquery',
    'Magento_Ui/js/modal/modal',
    'mage/translate'
], function ($) {
    'use strict';

    $.widget('mage.access_token', {
        options: {
            authorize_url: '',
            window: {
                title: $.mage.__('Instagram'),
                params: 'width=700,height=620,left=1862,top=326'
            },
            alertPopup: {
                modalWindow: 'aminst-modal-window',
                contentSelector: '.aminst-modal .aminst-modal-body-content',
                showMoreButtonSelector: '.aminst-show-more',
                errorSelector: '.aminst-error-text',
                defaultErrorMessage: $.mage.__('A response from Facebook was not received by the module, probably because the authorization was not completed')
            },
            activeClass: 'aminst-token-icon',
            accessToken: '.aminst-token-after'
        },

        _create: function () {
            var self = this;

            this.alert = require('Magento_Ui/js/modal/alert');
            this.options.accessToken = $(this.options.accessToken);

            this._on({
                'click': $.proxy(this._access, this)
            });

            $(document).on('click', this.options.alertPopup.showMoreButtonSelector, function() {
                self.showErrorText(this);
            });
        },

        showErrorText: function (button) {
            $(this.options.alertPopup.errorSelector).text(this.prepareErrorText());
            $(this.options.alertPopup.errorSelector).show();
            $(button).remove();
        },

        prepareErrorText: function () {
            var errorText = document.errorText;
            if (!errorText) {
                errorText = this.options.alertPopup.defaultErrorMessage;
            }

            return errorText;
        },

        _access: function () {
            var self = this;

            this.child = window.open(
              self._getUrl(),
              self.options.window.title,
              self.options.window.params
            );

            this._checkChild();
        },

        _checkChild: function () {
            var self = this,
                timer;

            timer = setInterval(function () {
                if (self.child.closed) {
                    if (document.isTokenGenerated) {
                        self._showIcon();
                    } else {
                        self._showAlert();
                    }

                    clearInterval(timer);
                }
            }, 1000);
        },

        _showAlert: function () {
            $(this.options.alertPopup.errorSelector).hide();

            this.alert({
                content: $(this.options.alertPopup.contentSelector).html(),
                modalClass: this.options.alertPopup.modalWindow
            });
        },

        _showIcon: function () {
            this.options.accessToken.addClass(this.options.activeClass);
        },

        _getUrl: function () {
            return this.options.authorize_url;
        }
    });

    return $.mage.access_token;
});
