<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Instagram Feed for Magento 2
 */

namespace Amasty\InstagramFeed\Observer;

use Amasty\InstagramFeed\Model\Instagram\Management;
use Magento\Framework\Event\Observer;
use Magento\Framework\Event\ObserverInterface;

class RunRegeneratePostsData implements ObserverInterface
{
    private const INSTAGRAM_SETTINGS = [
        'aminstagramfeed/video/download_video',
        'aminstagramfeed/hashtags/load_posts_by_hashtags',
        'aminstagramfeed/hashtags/posts_sort',
        'aminstagramfeed/hashtags/hashtags'
    ];

    /**
     * @var Management
     */
    private $management;

    public function __construct(
        Management $management
    ) {
        $this->management = $management;
    }

    public function execute(Observer $observer): void
    {
        $changedPaths = $observer->getEvent()->getData('changed_paths') ?? [];
        if (array_intersect($changedPaths, self::INSTAGRAM_SETTINGS)) {
            $storeId = $observer->getData('store') ? (int)$observer->getData('store') : null;
            $this->management->update($storeId, true);
        }
    }
}
