<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Instagram Feed for Magento 2
 */

namespace Amasty\InstagramFeed\Model\ResourceModel\Hashtag;

use Amasty\InstagramFeed\Api\Data\HashtagInterface;
use Amasty\InstagramFeed\Model\Hashtag as HashtagModel;
use Amasty\InstagramFeed\Model\ResourceModel\Hashtag;
use Magento\Framework\Model\ResourceModel\Db\Collection\AbstractCollection;

class Collection extends AbstractCollection
{
    /**
     * @var string
     */
    protected $_idFieldName = HashtagInterface::ID;

    protected function _construct()
    {
        $this->_init(
            HashtagModel::class,
            Hashtag::class
        );
    }
}
