<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Instagram Feed for Magento 2
 */

namespace Amasty\InstagramFeed\Model\Instagram\Video\VideoService\ServiceData;

use Magento\Framework\Api\AbstractSimpleObject;

class VideoServiceData extends AbstractSimpleObject implements VideoServiceDataInterface
{
    public const VIDEO_URL = 'url';
    public const VIDEO_EXT = 'ext';

    public function getVideoExt(): ?string
    {
        return $this->_get(self::VIDEO_EXT);
    }

    public function setVideoExt(string $extension): VideoServiceDataInterface
    {
        $this->setData(self::VIDEO_EXT, $extension);

        return $this;
    }

    public function getVideoUrl(): ?string
    {
        return $this->_get(self::VIDEO_URL);
    }

    public function setVideoUrl(string $videoUrl): VideoServiceDataInterface
    {
        $this->setData(self::VIDEO_URL, $videoUrl);

        return $this;
    }
}
