<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Instagram Feed for Magento 2
 */

namespace Amasty\InstagramFeed\Model\Instagram\Video\Manager;

use Amasty\InstagramFeed\Model\Instagram\Video\VideoService\ServiceData\VideoServiceDataInterface;
use Magento\Framework\Exception\ConfigurationMismatchException;

interface ManagerInterface
{
    /**
     * @throws ConfigurationMismatchException
     */
    public function save(VideoServiceDataInterface $videoData, int $postId, ?int $storeId): void;

    public function getVideoFileSystemPath(int $postId, ?int $storeId): ?string;
}
