<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Instagram Feed for Magento 2
 */

namespace Amasty\InstagramFeed\Model\Instagram\Video;

use Amasty\InstagramFeed\Model\Instagram\GarbageCollectorInterface;

class GarbageCollector implements GarbageCollectorInterface
{
    /**
     * @var array
     */
    private $allActualVideoPostsIds = [];

    public function collect(int $postId, int $instagramId): GarbageCollectorInterface
    {
        $this->allActualVideoPostsIds[$instagramId][] = $postId;

        return $this;
    }

    public function getActualPostsIds(): array
    {
        return $this->allActualVideoPostsIds;
    }
}
