<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Instagram Feed for Magento 2
 */

namespace Amasty\InstagramFeed\Model\Instagram;

use Amasty\InstagramFeed\Model\ConfigProvider;
use Magento\Framework\Exception\NoSuchEntityException;
use Magento\Store\Model\Store;
use Magento\Store\Model\StoreManagerInterface;

class IsMainInstagramSettingsDifferent
{
    /**
     * @var ConfigProvider
     */
    private $configProvider;

    /**
     * @var StoreManagerInterface
     */
    private $storeManager;

    public function __construct(
        ConfigProvider $configProvider,
        StoreManagerInterface $storeManager
    ) {
        $this->configProvider = $configProvider;
        $this->storeManager = $storeManager;
    }

    /**
     * @throws NoSuchEntityException
     */
    public function execute(?int $storeId = null): bool
    {
        $storeId = $storeId === null ? (int)$this->storeManager->getStore()->getId() : $storeId;

        $isVideoContentSettingDifferent = $this->configProvider->isVideoContentEnabled($storeId)
            != $this->configProvider->isVideoContentEnabled(Store::DEFAULT_STORE_ID);
        $isAccessTokenDifferent = $this->configProvider->getAccessToken($storeId)
            != $this->configProvider->getAccessToken(Store::DEFAULT_STORE_ID);
        $isHashtagSettingDifferent = $this->isHashtagSettingsDifferent($storeId);

        return $isVideoContentSettingDifferent || $isAccessTokenDifferent || $isHashtagSettingDifferent;
    }

    private function isHashtagSettingsDifferent(?int $storeId = null): bool
    {
        $isHashtagEnabledDifferent = $this->configProvider->isHashtagsEnabled($storeId)
            != $this->configProvider->isHashtagsEnabled(Store::DEFAULT_STORE_ID);
        $isHashtagSortingDifferent = $this->configProvider->getSortOfHashtagPosts($storeId)
            != $this->configProvider->getSortOfHashtagPosts(Store::DEFAULT_STORE_ID);
        $isHashtagsDifferent = $this->configProvider->getHashtags($storeId)
            != $this->configProvider->getHashtags(Store::DEFAULT_STORE_ID);

        return $isHashtagEnabledDifferent || $isHashtagSortingDifferent || $isHashtagsDifferent;
    }
}
