<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Instagram Feed for Magento 2
 */

namespace Amasty\InstagramFeed\Model\Instagram\Hashtag;

use Amasty\InstagramFeed\Api\Data\HashtagInterface;
use Amasty\InstagramFeed\Model\ResourceModel\Hashtag\CollectionFactory;

class GetHashtagInfo
{
    public const NEED_GET_FROM_API_HASHTAGS = 'need_get_from_api';

    public const DATABASE_HASHTAGS = 'database_storage';

    /**
     * @var CollectionFactory
     */
    private $hashtagCollectionFactory;

    public function __construct(
        CollectionFactory $hashtagCollectionFactory
    ) {
        $this->hashtagCollectionFactory = $hashtagCollectionFactory;
    }

    public function execute(array $hashtags): array
    {
        $collection = $this->hashtagCollectionFactory->create();
        $collection->addFieldToSelect([HashtagInterface::NAME, HashtagInterface::HASHTAG_ID]);

        // Workaround when passing an array to addFieldToFilter also modifies the original array
        $hashtagsString = implode(',', $hashtags);
        $collection->addFieldToFilter(HashtagInterface::NAME, ['in' => $hashtagsString]);
        $hashtagItems = $collection->getItems();

        $hashtagsWithInstagramIds = [];
        /** @var HashtagInterface $hashtagItem */
        foreach ($hashtagItems as $hashtagItem) {
            $hashtagsWithInstagramIds[$hashtagItem->getName()] = $hashtagItem->getHashtagId();
        }

        return [
            self::NEED_GET_FROM_API_HASHTAGS => array_diff($hashtags, array_flip($hashtagsWithInstagramIds)),
            self::DATABASE_HASHTAGS => $hashtagsWithInstagramIds
        ];
    }
}
