<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Instagram Feed for Magento 2
 */

namespace Amasty\InstagramFeed\Model;

use Amasty\InstagramFeed\Api\Data\HashtagInterface;
use Magento\Framework\Model\AbstractModel;

class Hashtag extends AbstractModel implements HashtagInterface
{
    protected function _construct()
    {
        parent::_construct();
        $this->_init(ResourceModel\Hashtag::class);
    }

    public function getId(): int
    {
        return (int)$this->_getData(HashtagInterface::ID);
    }

    /**
     * @param int $id
     * @return HashtagInterface
     */
    public function setId($id): HashtagInterface
    {
        $this->setData(HashtagInterface::ID, $id);

        return $this;
    }

    public function getHashtagId(): string
    {
        return (string)$this->_getData(HashtagInterface::HASHTAG_ID);
    }

    public function setHashtagId(string $hashtagId): HashtagInterface
    {
        $this->setData(HashtagInterface::HASHTAG_ID, $hashtagId);

        return $this;
    }

    public function getName(): string
    {
        return (string)$this->_getData(HashtagInterface::NAME);
    }

    public function setName(string $name): HashtagInterface
    {
        $this->setData(HashtagInterface::NAME, $name);

        return $this;
    }

    public function getTimestamp(): string
    {
        return (string)$this->_getData(HashtagInterface::TIMESTAMP);
    }

    public function setTimestamp(string $timestamp): HashtagInterface
    {
        $this->setData(HashtagInterface::TIMESTAMP, $timestamp);

        return $this;
    }
}
