<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Instagram Feed for Magento 2
 */

namespace Amasty\InstagramFeed\Controller\Token;

use Amasty\InstagramFeed\Model\ConfigProvider;
use Amasty\InstagramFeed\Model\Instagram\Client;
use Magento\Framework\App\Action\Action;
use Magento\Framework\App\Action\Context;
use Magento\Framework\Controller\ResultFactory;
use Magento\Store\Model\Store;

class Save extends Action
{
    /**
     * @var Client
     */
    private $client;

    /**
     * @var ConfigProvider
     */
    private $configProvider;

    public function __construct(
        Context $context,
        ConfigProvider $configProvider,
        Client $client
    ) {
        parent::__construct($context);
        $this->configProvider = $configProvider;
        $this->client = $client;
    }

    public function execute()
    {
        if (!$this->checkInternalToken()) {
            $resultForward = $this->resultFactory->create(ResultFactory::TYPE_FORWARD);
            return $resultForward->forward('noroute');
        }

        $token = $this->getRequest()->getParam('token');
        $error = '';
        try {
            if ($userId = $this->client->getUserIdByToken($token)) {
                $storeId = $this->getRequest()->getParam('store_id', Store::DEFAULT_STORE_ID);
                $this->configProvider->saveAccessToken($token, $storeId)->saveUserId($userId, $storeId);
            }
        } catch (\Exception $e) {
            $error = $e->getMessage();
        }

        $resultJson = $this->resultFactory->create(ResultFactory::TYPE_JSON);

        $resultData = [
            'success' => empty($error),
            'message' => $error
        ];

        return $resultJson->setData($resultData);
    }

    private function checkInternalToken(): bool
    {
        return $this->getRequest()->getParam('internal_token') === $this->configProvider->getInternalToken();
    }
}
