<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Instagram Feed for Magento 2
 */

namespace Amasty\InstagramFeed\Controller\Adminhtml\Token;

use Amasty\InstagramFeed\Model\ConfigProvider;
use Magento\Backend\App\Action;
use Magento\Backend\App\Action\Context;
use Magento\Framework\App\Action\HttpPostActionInterface;

class Delete extends Action implements HttpPostActionInterface
{
    /**
     * @var ConfigProvider
     */
    private $configProvider;

    public function __construct(ConfigProvider $configProvider, Context $context)
    {
        parent::__construct($context);
        $this->configProvider = $configProvider;
    }

    public function execute()
    {
        $storeId = (int)$this->getRequest()->getParam('store_id');
        $this->configProvider->removeAccessToken($storeId);
        $this->configProvider->removeUserId($storeId);

        $this->messageManager->addSuccessMessage(__('Token was deleted.'));
    }
}
