<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Instagram Feed for Magento 2
 */

namespace Amasty\InstagramFeed\Console\Command;

use Amasty\InstagramFeed\Model\Instagram\Management;
use Magento\Setup\Console\Command\AbstractSetupCommand;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;

class UpdateImages extends AbstractSetupCommand
{
    public const MESSAGE_SUCCESS = '<info>Images has been generated successfully</info>';
    public const MESSAGE_ERROR = '<error>%s</error>';

    /**
     * @var Management
     */
    private $management;

    public function __construct(
        Management $management,
        $name = null
    ) {
        $this->management = $management;
        parent::__construct($name);
    }

    protected function configure(): void
    {
        $this->setName('amasty:instafeed:update');
        $this->setDescription('Update Amasty Instagram Images');
        parent::configure();
    }

    protected function execute(InputInterface $input, OutputInterface $output): int
    {
        try {
            $this->management->update();
            $output->writeln(self::MESSAGE_SUCCESS);
        } catch (\Exception $e) {
            $output->writeln(sprintf(self::MESSAGE_ERROR, $e->getMessage()));
        }

        return 0;
    }
}
