<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Instagram Feed for Magento 2
 */

namespace Amasty\InstagramFeed\Block\Widget\Feed;

/**
 * Class Slider
 *
 * Implements posts slider
 */
class Slider extends AbstractGrid
{
    public const HTML_ID = 'aminst-wrapper-';

    /**
     * Default swiper autoplay speed
     */
    public const DEFAULT_SLIDER_AUTOPLAY_SPEED = 2000;

    /**
     * @var string
     */
    protected $_template = 'Amasty_InstagramFeed::widget/feed/content/slider.phtml';

    public function getColumnsCount(): int
    {
        return (int)$this->getData('columns_count') ?: 1;
    }

    public function getRowsCount(): int
    {
        return (int)$this->getData('rows_count') ?: 1;
    }

    public function isAutoplayEnabled(): bool
    {
        return (bool)$this->getData('autoplay');
    }

    public function getAutoplaySpeed(): int
    {
        if (!$this->hasData('autoplay_delay')) {
            $this->setData('autoplay_delay', self::DEFAULT_SLIDER_AUTOPLAY_SPEED);
        }

        return (int)$this->getData('autoplay_delay');
    }

    public function isPaginationShow(): bool
    {
        $isPaginationShow = $this->getData('pagination_show');
        if (null === $isPaginationShow) {
            return true;
        }

        return (bool)$isPaginationShow;
    }

    public function isButtonsShow(): bool
    {
        $isButtonsShow = $this->getData('buttons_show');
        if (null === $isButtonsShow) {
            return true;
        }

        return (bool)$isButtonsShow;
    }

    public function getLoop(): int
    {
        return (int)$this->getData('infinity_loop') ?: 1;
    }
}
