<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Instagram Feed for Magento 2
 */

namespace Amasty\InstagramFeed\Block\Adminhtml\System\Config;

use Amasty\InstagramFeed\Model\ConfigProvider;
use Magento\Backend\Block\Template\Context;
use Magento\Config\Block\System\Config\Form\Field;
use Magento\Framework\Data\Form\Element\AbstractElement;
use Magento\Framework\Serialize\Serializer\Json as Serializer;
use Magento\Store\Model\Store;

class DeleteAccessToken extends Field
{
    /**
     * @var Serializer
     */
    private $serializer;

    /**
     * @var ConfigProvider
     */
    private $configProvider;

    public function __construct(
        Serializer $serializer,
        ConfigProvider $configProvider,
        Context $context,
        array $data = []
    ) {
        parent::__construct($context, $data);
        $this->serializer = $serializer;
        $this->configProvider = $configProvider;
    }

    /**
     * @return $this
     */
    protected function _prepareLayout()
    {
        parent::_prepareLayout();
        $this->setTemplate('Amasty_InstagramFeed::system/config/delete_access_token.phtml');

        return $this;
    }

    /**
     * @param AbstractElement $element
     * @return string
     */
    public function render(AbstractElement $element)
    {
        $currentAccessToken = $this->configProvider->getAccessToken($this->getCurrentStoreId());
        $defaultAccessToken = $this->getCurrentStoreId()
            ? $this->configProvider->getAccessToken(Store::DEFAULT_STORE_ID)
            : null;
        if (!$currentAccessToken || $currentAccessToken === $defaultAccessToken) {
            return '';
        }

        $element = clone $element;
        $element->unsScope()->unsCanUseWebsiteValue()->unsCanUseDefaultValue();

        return parent::render($element);
    }

    /**
     * @param AbstractElement $element
     * @return string
     */
    protected function _getElementHtml(AbstractElement $element)
    {
        $this->addData([
            'button_label' => $element->getOriginalData('button_label'),
            'json_config' => $this->generateDeleteAccessTokenConfig(),
            'html_id' => $element->getHtmlId()
        ]);

        return $this->_toHtml();
    }

    private function generateDeleteAccessTokenConfig(): string
    {
        return $this->serializer->serialize([
            'data' => [
                'action_url' => $this->getUrl('aminstagramfeed/token/delete'),
                'store_id' => $this->getCurrentStoreId()
            ]
        ]);
    }

    private function getCurrentStoreId(): int
    {
        return (int) $this->getRequest()->getParam('store');
    }
}
