<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Instagram Feed for Magento 2
 */

namespace Amasty\InstagramFeed\Api\Data;

interface HashtagInterface
{
    public const MAIN_TABLE = 'amasty_instagramfeed_hashtags';

    public const ID = 'id';

    public const HASHTAG_ID  = 'hashtag_id';

    public const NAME = 'name';

    public const TIMESTAMP = 'timestamp';

    /**
     * @return int
     */
    public function getId(): int;

    /**
     * @param int $id
     * @return \Amasty\InstagramFeed\Api\Data\HashtagInterface
     */
    public function setId(int $id): HashtagInterface;

    /**
     * @return string
     */
    public function getHashtagId(): string;

    /**
     * @param string $hashtagId
     * @return \Amasty\InstagramFeed\Api\Data\HashtagInterface
     */
    public function setHashtagId(string $hashtagId): HashtagInterface;

    /**
     * @return string
     */
    public function getName(): string;

    /**
     * @param string $name
     * @return \Amasty\InstagramFeed\Api\Data\HashtagInterface
     */
    public function setName(string $name): HashtagInterface;

    /**
     * @return string
     */
    public function getTimestamp(): string;

    /**
     * @param string $timestamp
     * @return \Amasty\InstagramFeed\Api\Data\HashtagInterface
     */
    public function setTimestamp(string $timestamp): HashtagInterface;
}
