<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Amasty Improved Sorting GraphQl for Magento 2 (System)
 */

use Magento\Catalog\Api\ProductRepositoryInterface;
use Magento\Customer\Api\CustomerRepositoryInterface;
use Magento\TestFramework\Helper\Bootstrap;
use Magento\Wishlist\Model\WishlistFactory;
use Magento\TestFramework\Workaround\Override\Fixture\Resolver;

Resolver::getInstance()->requireDataFixture('Magento/Customer/_files/customer_with_addresses.php');

$objectManager = Bootstrap::getObjectManager();

/** @var CustomerRepositoryInterface $customerRepository */
$customerRepository = Bootstrap::getObjectManager()->create(CustomerRepositoryInterface::class);

/** @var ProductRepositoryInterface $productRepository */
$productRepository = $objectManager->create(ProductRepositoryInterface::class);

/** @var WishlistFactory $wishlistFactory */
$wishlistFactory = $objectManager->get(WishlistFactory::class);

$customer = $customerRepository->get('customer_with_addresses@test.com');

$productOne = $productRepository->get('am_sort_simple_4');
$productTwo = $productRepository->get('am_sort_virtual_1');

$wishlist = $wishlistFactory->create();
$wishlist->loadByCustomerId($customer->getId(), true);

$wishlist->addNewItem($productOne);
$wishlist->addNewItem($productTwo);

$wishlist->save();
