define([
    'jquery',
    'mage/translate',
    'Amasty_GiftWrap/vendor/amcharts4/core.min',
    'Amasty_GiftWrap/vendor/amcharts4/charts.min',
    'Amasty_GiftWrap/vendor/amcharts4/animated.min'
], function ($) {
    'use strict';

    $.widget('mage.columnCharts', {
        options: {
            data: {},
            wraps: {},
            initSelector: 'amwrap-overview',
            gridTemplateLocation: 0,
            labelsTemplateLocation: 0.5,
            dateMinGridDistance: 60,
            valueTitle: 'Qty Sold',
            valueMin: 0,
            valueMinGridDistance: 100,
            dateTimeUnit: 'day',
            dateUnitCount: 1
        },

        _create: function () {
            var self = this,
                options = self.options,
                chart = am4core.create(this.options.initSelector, am4charts.XYChart),
                dateAxis = chart.xAxes.push(new am4charts.DateAxis()),
                valueAxis = chart.yAxes.push(new am4charts.ValueAxis());

            am4core.useTheme(am4themes_animated);
            chart.scrollbarX = new am4core.Scrollbar();
            chart.data = options.data;

            dateAxis.renderer.grid.template.location = options.gridTemplateLocation;
            dateAxis.renderer.minGridDistance = options.dateMinGridDistance;
            dateAxis.renderer.labels.template.location = options.labelsTemplateLocation;
            dateAxis.groupData = true;
            dateAxis.periodChangeDateFormats.setKey('month', '[bold]MMM yyyy[/]');
            dateAxis.baseInterval = {
                'timeUnit': options.dateTimeUnit,
                'count': options.dateUnitCount
            };

            valueAxis.min = options.valueMin;
            valueAxis.renderer.minGridDistance = options.valueMinGridDistance;
            valueAxis.title.text = $.mage.__(options.valueTitle);

            $.each(self.options.wraps, function (index, element) {
                self._createSeries(chart, index, element, true);
            });

            chart.legend = new am4charts.Legend();
        },

        _createSeries: function (chart, field, name, stacked) {
            var series = chart.series.push(new am4charts.ColumnSeries());

            series.dataFields.valueY = field;
            if (!series.groupFields) {
                series.groupFields = {};
            }
            series.groupFields.valueY = 'sum';
            series.dataFields.dateX = 'date';
            series.name = name;
            series.columns.template.tooltipText = '{name}: [bold]{valueY}[/]';
            series.stacked = stacked;
            series.columns.template.width = am4core.percent(95);
        }
    });

    return $.mage.columnCharts;
});
