define([
    'jquery'
], function ($) {
    'use strict';

    $.widget('amfollowup.upload', {
        options: {
            selectors: {
                filename: '[data-amfollowup-js="filename"]',
                fileInput: '[data-amfollowup-js="file"]'
            }
        },

        _create: function () {
            $(this.options.selectors.fileInput).on('change', this.changeFileName.bind(this));
        },

        changeFileName: function (event) {
            $(this.options.selectors.filename).html(event.target.files[0].name);
        }
    });

    return $.amfollowup.upload;
});
