/**
 * Amasty Followup schedule item component
 */

define([
    'uiElement'
], function (Element) {
    'use strict';

    return Element.extend({
        defaults: {
            isShowExtra: false,
            links: {
                schedule_id: '${ $.provider }:${ $.dataScope }.schedule_id',
                email_template_id: '${ $.provider }:${ $.dataScope }.email_template_id',
                days: '${ $.provider }:${ $.dataScope }.days',
                hours: '${ $.provider }:${ $.dataScope }.hours',
                minutes: '${ $.provider }:${ $.dataScope }.minutes',
                coupon_type: '${ $.provider }:${ $.dataScope }.coupon_type',
                discount_amount: '${ $.provider }:${ $.dataScope }.discount_amount',
                discount_qty: '${ $.provider }:${ $.dataScope }.discount_qty',
                expired_in_days: '${ $.provider }:${ $.dataScope }.expired_in_days',
                discount_step: '${ $.provider }:${ $.dataScope }.discount_step',
                use_rule: '${ $.provider }:${ $.dataScope }.use_rule',
                sales_rule_id: '${ $.provider }:${ $.dataScope }.sales_rule_id'
            },
        },

        initObservable: function () {
            this._super().observe([
                'isShowExtra',
                'schedule_id',
                'email_template_id',
                'days',
                'hours',
                'minutes',
                'coupon_type',
                'discount_amount',
                'discount_qty',
                'expired_in_days',
                'discount_step',
                'use_rule',
                'sales_rule_id'
            ]);

            return this;
        },

        onCheckedChanged: function (value, index) {
            value(Number(value()));
        },

        /**
         * Toggle more fields
         * @returns {void}
         */
        toggleMoreInfo: function () {
            this.isShowExtra(!this.isShowExtra());
        }
    });
});
