/**
 * Amasty Followup schedule component
 */

define([
    'jquery',
    'uiCollection',
    'uiLayout',
    'mageUtils',
    'Magento_Ui/js/modal/confirm',
    'mage/translate'
], function ($, Collection, layout, utils, confirm, $t) {
    'use strict';

    return Collection.extend({
        defaults: {
            htmlId: '',
            htmlName: '',
            dataScope: 'schedules',
            salesRuleData: '',
            schedules: [],
            elemIndex: 0
        },

        initialize: function () {
            this._super();

            this.initFields();

            return this;
        },

        /**
         * get numeric options
         * @param {Number} lastNum
         * @returns {Array}
         */
        getNumericOptions: function (lastNum) {
            var array = Array.apply(null, { length: lastNum }).map(function (item, index) {
                return {
                    label: index + 1,
                    value: index + 1
                };
            });

            array.unshift({ label: '-' });

            return array;
        },

        /**
         * Prepare sales rule array to select
         * @returns {Array}
         */
        getSalesRuleData: function () {
            return this.salesRuleData;
        },

        /**
         * Create new record
         * @returns {void}
         */
        addRecord: function () {
            this.initField({});
        },

        /**
         * Initialize new record
         * @returns {void}
         */
        initFields: function () {
            this.schedules.forEach(function (item) {
                this.initField(item);
            }.bind(this));
        },

        /**
         * Initialize child component
         * @param {Object} item
         * @returns {void}
         */
        initField: function (item) {
            var schedule = this.createField(item, this.elemIndex, this.dataScope);

            layout([schedule]);
            this.insertChild(schedule.name, this.elemIndex);
            this.elemIndex += 1;
        },

        /**
         * Create component
         * @param {Object} data
         * @param {Number} index
         * @param {String} dataScope
         * @returns {Object}
         */
        createField: function (data, index, dataScope) {
            return utils.extend(data, {
                'name': this.name + '.' + index,
                'provider': this.provider,
                'component': 'Amasty_Followup/js/scheduleItem',
                'dataScope': dataScope + '.' + index,
                'sortOrder': index,
                'template': 'Amasty_Followup/schedule'
            });
        },

        /**
         * Delete Item
         * @returns {void}
         */
        deleteItem: function (data) {
            confirm({
                content: $t('Are you sure?'),
                actions: {
                    confirm: function () {
                        data.source.remove(data.dataScope);
                        data.destroy();
                    }
                }
            });
        }
    });
});
