<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Follow Up Email for Magento 2
 */

namespace Amasty\Followup\Ui\DataProvider\Rule\Modifier;

use Amasty\Followup\Model\ThirdParty\ModuleChecker;
use Magento\Framework\Stdlib\ArrayManager;
use Magento\Ui\DataProvider\Modifier\ModifierInterface;

class Segments implements ModifierInterface
{
    /**
     * @var ArrayManager
     */
    private $arrayManager;

    /**
     * @var ModuleChecker
     */
    private $moduleChecker;

    public function __construct(
        ArrayManager $arrayManager,
        ModuleChecker $moduleChecker
    ) {
        $this->arrayManager = $arrayManager;
        $this->moduleChecker = $moduleChecker;
    }

    public function modifyData(array $data)
    {
        return $data;
    }

    public function modifyMeta(array $meta)
    {
        if (!$this->moduleChecker->isAmastySegmentEnabled()) {
            $path = 'segments_fieldset/arguments/data/config';
            $config = [
                'componentDisabled' => true
            ];

            $meta = $this->arrayManager->set($path, $meta, $config);
        }

        return $meta;
    }
}
