<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Follow Up Email for Magento 2
 */

namespace Amasty\Followup\Ui\DataProvider\Rule\Modifier;

use Amasty\Followup\Model\Rule\Locator;
use Amasty\Followup\Model\Source\Rule\EmailTemplates;
use Amasty\Followup\Model\Source\SalesRules;
use Magento\Framework\Stdlib\ArrayManager;
use Magento\Ui\DataProvider\Modifier\ModifierInterface;

class Schedule implements ModifierInterface
{
    /**
     * @var Locator
     */
    private $ruleLocator;

    /**
     * @var SalesRules
     */
    private $salesRulesOptions;

    /**
     * @var EmailTemplates
     */
    private $emailTemplatesOptions;

    /**
     * @var ArrayManager
     */
    private $arrayManager;

    public function __construct(
        Locator $ruleLocator,
        SalesRules $salesRulesOptions,
        EmailTemplates $emailTemplatesOptions,
        ArrayManager $arrayManager
    ) {
        $this->ruleLocator = $ruleLocator;
        $this->salesRulesOptions = $salesRulesOptions;
        $this->emailTemplatesOptions = $emailTemplatesOptions;
        $this->arrayManager = $arrayManager;
    }

    public function modifyData(array $data): array
    {
        $rule = $this->ruleLocator->getRule();
        if ($rule->getRuleId() && !isset($data['schedule'])) {
            $preparedSchedules = [];
            $schedules = $rule->getScheduleCollection();
            /** @var \Amasty\Followup\Model\Schedule $schedule */
            foreach ($schedules as $schedule) {
                $preparedSchedules[] = $schedule->getConfig();
            }
            $data['schedule'] = $preparedSchedules;
        }

        if (isset($data['schedule'])) {
            foreach ($data['schedule'] as &$schedule) {
                $schedule['use_rule'] = isset($schedule['use_rule']) ? (int)$schedule['use_rule'] : 0;
            }
        }

        return $data;
    }

    public function modifyMeta(array $meta): array
    {
        $rule = $this->ruleLocator->getRule();
        if ($rule->getRuleId()) {
            $path = 'schedule_fieldset/children/schedule/arguments/data/config';
            $config = [
                'htmlId' => 'amasty_rule_schedule',
                'htmlName' => 'schedule',
                'emailTemplates' => $this->emailTemplatesOptions->getByType($rule->getStartEventType()),
                'isShowSalesRuleSelect' => $this->salesRulesOptions->isLessThanLimit(),
                'salesRuleData' => $this->salesRulesOptions->toOptionArray()
            ];

            $meta = $this->arrayManager->set($path, $meta, $config);
        }

        return $meta;
    }
}
