<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Follow Up Email for Magento 2
 */

namespace Amasty\Followup\Ui\DataProvider\Rule\Modifier;

use Amasty\Followup\Model\Rule\Locator;
use Magento\Framework\Stdlib\ArrayManager;
use Magento\Ui\DataProvider\Modifier\ModifierInterface;
use Amasty\Followup\Model\Source\Rule\CancelEventType as CancelEventTypeSource;

class CancelEventType implements ModifierInterface
{
    /**
     * @var Locator
     */
    private $ruleLocator;

    /**
     * @var CancelEventTypeSource
     */
    private $cancelEventType;

    /**
     * @var ArrayManager
     */
    private $arrayManager;

    public function __construct(
        Locator $ruleLocator,
        CancelEventTypeSource $cancelEventType,
        ArrayManager $arrayManager
    ) {
        $this->ruleLocator = $ruleLocator;
        $this->cancelEventType = $cancelEventType;
        $this->arrayManager = $arrayManager;
    }

    public function modifyData(array $data): array
    {
        return $data;
    }

    public function modifyMeta(array $meta): array
    {
        $rule = $this->ruleLocator->getRule();
        if ($rule->getRuleId()) {
            $path = 'general_fieldset/children/cancel_event_type/arguments/data/config';
            $config = $this->arrayManager->get($path, $meta) ?? [];
            $config = array_merge(
                $config,
                [
                    'options' => $this->cancelEventType->getByType($rule->getStartEventType())
                ]
            );

            $meta = $this->arrayManager->set($path, $meta, $config);
        }

        return $meta;
    }
}
