<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Follow Up Email for Magento 2
 */

namespace Amasty\Followup\Ui\DataProvider\Rule;

use Amasty\Followup\Api\Data\RuleInterface;
use Amasty\Followup\Controller\Adminhtml\Rule\Save;
use Amasty\Followup\Model\ResourceModel\Rule\CollectionFactory;
use Magento\Framework\App\Request\DataPersistorInterface;
use Magento\Framework\App\RequestInterface;
use Magento\Ui\DataProvider\AbstractDataProvider;
use Magento\Ui\DataProvider\Modifier\PoolInterface;

class Form extends AbstractDataProvider
{
    public const FORM_NAMESPACE = 'amasty_followup_rule_form';

    /**
     * @var RequestInterface
     */
    private $request;

    /**
     * @var DataPersistorInterface
     */
    private $dataPersistor;

    /**
     * @var PoolInterface
     */
    private $modifiersPool;

    public function __construct(
        $name,
        $primaryFieldName,
        $requestFieldName,
        CollectionFactory $collectionFactory,
        RequestInterface $request,
        DataPersistorInterface $dataPersistor,
        PoolInterface $modifiersPool,
        array $meta = [],
        array $data = []
    ) {
        parent::__construct($name, $primaryFieldName, $requestFieldName, $meta, $data);
        $this->collection = $collectionFactory->create();
        $this->request = $request;
        $this->dataPersistor = $dataPersistor;
        $this->modifiersPool = $modifiersPool;
    }

    public function getData()
    {
        $formData = $this->dataPersistor->get(Save::DATA_PERSISTOR_KEY);
        if (!empty($formData)
            && is_array($formData)
        ) {
            $id = $formData[RuleInterface::RULE_ID] ?? null;
            $this->dataPersistor->clear(Save::DATA_PERSISTOR_KEY);
            $ruleData = $formData;
        } else {
            $id = $this->request->getParam($this->getRequestFieldName());
            $rule = $this->getCollection()->addFieldToFilter(RuleInterface::RULE_ID, $id)->getFirstItem();
            if (!$rule) {
                $rule = $this->collection->getNewEmptyItem();
            }
            $ruleData = $rule->getData();
        }
        foreach ($this->modifiersPool->getModifiersInstances() as $modifier) {
            $ruleData = $modifier->modifyData($ruleData);
        }
        $data[$id] = $ruleData;

        return $data;
    }

    public function getMeta()
    {
        $meta = parent::getMeta();
        foreach ($this->modifiersPool->getModifiersInstances() as $modifier) {
            $meta = $modifier->modifyMeta($meta);
        }

        return $meta;
    }
}
