<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Follow Up Email for Magento 2
 */

namespace Amasty\Followup\Ui\DataProvider\History;

use Amasty\Followup\Model\ResourceModel\History\CollectionFactory;

class HistoryDataProvider extends \Magento\Ui\DataProvider\AbstractDataProvider
{
    /**
     * @var bool
     */
    protected $collectionInitialized = false;

    public function __construct(
        $name,
        $primaryFieldName,
        $requestFieldName,
        CollectionFactory $collectionFactory,
        array $meta = [],
        array $data = []
    ) {
        parent::__construct($name, $primaryFieldName, $requestFieldName, $meta, $data);
        $this->collection = $collectionFactory->create();
    }

    public function getCollection()
    {
        $collection = parent::getCollection();
        $collection->addFieldToFilter(
            'main_table.status',
            ['neq' => \Amasty\Followup\Model\History::STATUS_PENDING]
        );

        if (!$this->collectionInitialized) {
            $collection->addRuleData();

            $this->collectionInitialized = true;
        }

        return $collection;
    }
}
