<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Follow Up Email for Magento 2
 */

namespace Amasty\Followup\Ui\Component\Listing\Column;

use Amasty\Followup\Model\ThirdParty\ModuleChecker;
use Magento\Framework\View\Element\UiComponent\ContextInterface;
use Magento\Framework\View\Element\UiComponentFactory;
use Magento\Ui\Component\Listing\Columns\Column;

class Segment extends Column
{
    /**
     * @var ModuleChecker
     */
    private $moduleChecker;

    public function __construct(
        ContextInterface $context,
        UiComponentFactory $uiComponentFactory,
        ModuleChecker $moduleChecker,
        array $components = [],
        array $data = []
    ) {
        $this->moduleChecker = $moduleChecker;
        parent::__construct($context, $uiComponentFactory, $components, $data);
    }

    /**
     * Prepare component configuration
     *
     * @return void
     */
    public function prepare()
    {
        parent::prepare();
        if (!$this->moduleChecker->isAmastySegmentEnabled()) {
            $this->_data['config']['componentDisabled'] = true;
        }
    }
}
