<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Follow Up Email for Magento 2
 */

namespace Amasty\Followup\Ui\Component\Listing\Column\Rule\Grid;

use Amasty\Followup\Model\ConfigProvider;
use Magento\Framework\View\Element\UiComponent\ContextInterface;
use Magento\Framework\View\Element\UiComponentFactory;
use Magento\Ui\Component\Listing\Columns\Column;

class Run extends Column
{
    /**
     * @var ConfigProvider
     */
    private $configProvider;

    public function __construct(
        ContextInterface $context,
        UiComponentFactory $uiComponentFactory,
        ConfigProvider $configProvider,
        array $components = [],
        array $data = []
    ) {
        parent::__construct($context, $uiComponentFactory, $components, $data);
        $this->configProvider = $configProvider;
    }

    public function prepare()
    {
        parent::prepare();
        $config = $this->getData('config');
        $config['test'] = $this->configProvider->getRecipientEmailForTest()
            ? $this->configProvider->getRecipientEmailForTest()
            : false;
        $this->setData('config', $config);
    }
}
