<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Follow Up Email for Magento 2
 */

namespace Amasty\Followup\Ui\Component\Listing\Column\History\Status;

use Magento\Framework\Data\OptionSourceInterface;
use Amasty\Followup\Model\History as History;

class Options implements OptionSourceInterface
{
    public function toArray()
    {
        return [
            History::STATUS_PROCESSING => __('Processing'),
            History::STATUS_SENT => __('Sent'),
            History::STATUS_CANCEL => __('Cancel'),
            History::STATUS_NO_PRODUCT => __('No Product')
        ];
    }

    public function toOptionArray()
    {
        return [
            [
                'value' => History::STATUS_PROCESSING,
                'label' => __("Processing")
            ],
            [
                'value' => History::STATUS_SENT,
                'label' => __("Sent")
            ],
            [
                'value' => History::STATUS_CANCEL,
                'label' => __("Cancel")
            ],
            [
                'value' => History::STATUS_NO_PRODUCT,
                'label' => __("No Product")
            ],
        ];
    }
}
