<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Follow Up Email for Magento 2
 */

namespace Amasty\Followup\Ui\Component\Listing\Column\History\Reason;

use Magento\Framework\Data\OptionSourceInterface;
use Amasty\Followup\Model\History as History;

class Options implements OptionSourceInterface
{
    public function toArray()
    {
        return [
            History::REASON_BLACKLIST => __('Black List'),
            History::REASON_EVENT => __('Stop Event'),
            History::REASON_ADMIN => __('Removed by Admin'),
            History::REASON_NOT_SUBSCRIBED => __('Customer not subscribed'),
        ];
    }

    public function toOptionArray()
    {
        return [
            [
                'value' => History::REASON_BLACKLIST,
                'label' => __("Black List")
            ],
            [
                'value' => History::REASON_EVENT,
                'label' => __("Stop Event")
            ],
            [
                'value' => History::REASON_ADMIN,
                'label' => __("Removed by Admin")
            ],
            [
                'value' => History::REASON_NOT_SUBSCRIBED,
                'label' => __("Customer not subscribed")
            ],
        ];
    }
}
