<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Follow Up Email for Magento 2
 */

namespace Amasty\Followup\Setup;

use Amasty\Followup\Model\Event\Basic;
use Amasty\Followup\Model\ResourceModel\Blacklist;
use Amasty\Followup\Model\ResourceModel\History;
use Amasty\Followup\Model\ResourceModel\Link;
use Amasty\Followup\Model\ResourceModel\Rule;
use Amasty\Followup\Model\ResourceModel\Schedule;
use Magento\Framework\Setup\ModuleContextInterface;
use Magento\Framework\Setup\SchemaSetupInterface;
use Magento\Framework\Setup\UninstallInterface;

class Uninstall implements UninstallInterface
{
    public function uninstall(SchemaSetupInterface $setup, ModuleContextInterface $context)
    {
        $this->uninstallTables($setup)
            ->uninstallConfigData($setup)
            ->uninstallFlagData($setup)
            ->removeEmailTemplates($setup);
    }

    private function uninstallTables(SchemaSetupInterface $setup): self
    {
        $tablesToDrop = [
            Rule::RULE_SEGMENT_TABLE,
            Rule::RULE_CUSTOMER_GROUP_TABLE,
            Rule::RULE_STORE_TABLE,
            History::TABLE_NAME,
            Schedule::TABLE_NAME,
            Rule::RULE_ATTRIBUTE_TABLE,
            Blacklist::TABLE_NAME,
            Link::TABLE_NAME,
            Rule::RULE_TABLE
        ];
        foreach ($tablesToDrop as $table) {
            $setup->getConnection()->dropTable(
                $setup->getTable($table)
            );
        }

        return $this;
    }

    private function uninstallConfigData(SchemaSetupInterface $setup): self
    {
        $setup->getConnection()->delete(
            $setup->getTable('core_config_data'),
            "`path` LIKE 'amfollowup%'"
        );

        return $this;
    }

    private function uninstallFlagData(SchemaSetupInterface $setup): self
    {
        $setup->getConnection()->delete(
            $setup->getTable('flag'),
            '`flag_code` LIKE \'' . Basic::LAST_EXECUTED_PATH . '%\''
        );

        return $this;
    }

    private function removeEmailTemplates(SchemaSetupInterface $setup): self
    {
        $setup->getConnection()->delete(
            $setup->getTable('email_template'),
            '`orig_template_code` LIKE \'amfollowup_%\''
        );

        return $this;
    }
}
