<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Follow Up Email for Magento 2
 */

namespace Amasty\Followup\Setup\Patch\DeclarativeSchemaApplyBefore;

use Amasty\Followup\Model\ResourceModel\Rule;
use Amasty\Followup\Setup\Operation\RuleRelationData\CollectRuleData;
use Magento\Framework\Setup\ModuleDataSetupInterface;
use Magento\Framework\Setup\Patch\DataPatchInterface;

class CollectRule implements DataPatchInterface
{
    /**
     * @var ModuleDataSetupInterface
     */
    private $moduleDataSetup;

    /**
     * @var CollectRuleData
     */
    private $collectRuleData;

    public function __construct(
        ModuleDataSetupInterface $moduleDataSetup,
        CollectRuleData $collectRuleData
    ) {
        $this->moduleDataSetup = $moduleDataSetup;
        $this->collectRuleData = $collectRuleData;
    }

    public function apply()
    {
        $ruleTable = $this->moduleDataSetup->getTable(Rule::RULE_TABLE);
        if ($this->moduleDataSetup->getConnection()->isTableExists($ruleTable)
            && $this->moduleDataSetup->getConnection()->tableColumnExists($ruleTable, 'stores')
            && $this->moduleDataSetup->getConnection()->tableColumnExists($ruleTable, 'cust_groups')
            && $this->moduleDataSetup->getConnection()->tableColumnExists($ruleTable, 'segments')
        ) {
            $this->collectRuleData->execute();
        }
    }

    public static function getDependencies(): array
    {
        return [];
    }

    public function getAliases(): array
    {
        return [];
    }
}
