<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Follow Up Email for Magento 2
 */

namespace Amasty\Followup\Setup\Patch\Data;

use Magento\Framework\App\Config\ConfigResource\ConfigInterface;
use Magento\Framework\Module\ResourceInterface;
use Magento\Framework\Setup\Patch\DataPatchInterface;

class UpdateEmailConfig implements DataPatchInterface
{
    /**
     * @var ResourceInterface
     */
    private $moduleResource;

    /**
     * @var ConfigInterface
     */
    private $resourceConfig;

    public function __construct(
        ResourceInterface $moduleResource,
        ConfigInterface $resourceConfig
    ) {
        $this->moduleResource = $moduleResource;
        $this->resourceConfig = $resourceConfig;
    }

    public function apply()
    {
        $setupDataVersion = (string)$this->moduleResource->getDataVersion('Amasty_Followup');
        if ($setupDataVersion && version_compare($setupDataVersion, '1.2.16', '<')) {
            $connection = $this->resourceConfig->getConnection();
            $values = [
                'amfollowup/emails/name' => 'amfollowup/template/name',
                'amfollowup/emails/email' => 'amfollowup/template/email',
                'amfollowup/emails/cc' => 'amfollowup/template/cc'
            ];
            foreach ($values as $newValue => $oldValue) {
                $connection->update(
                    $this->resourceConfig->getMainTable(),
                    ['path' => $newValue],
                    ['path = ?' => $oldValue]
                );
            }
        }
    }

    public static function getDependencies()
    {
        return [];
    }

    public function getAliases()
    {
        return [];
    }
}
