<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Follow Up Email for Magento 2
 */

namespace Amasty\Followup\Setup\Patch\Data;

use Amasty\Followup\Model\ResourceModel\Rule;
use Amasty\Followup\Setup\Operation\RuleRelationData\CollectRuleData;
use Amasty\Followup\Setup\Operation\RuleRelationData\RuleRegistry;
use Magento\Framework\Setup\ModuleDataSetupInterface;
use Magento\Framework\Setup\Patch\DataPatchInterface;

class MigrateRuleRelationData implements DataPatchInterface
{
    /**
     * @var RuleRegistry
     */
    private $ruleRegistry;

    /**
     * @var ModuleDataSetupInterface
     */
    private $moduleDataSetup;

    public function __construct(
        RuleRegistry $ruleRegistry,
        ModuleDataSetupInterface $moduleDataSetup
    ) {
        $this->ruleRegistry = $ruleRegistry;
        $this->moduleDataSetup = $moduleDataSetup;
    }

    public function apply()
    {
        $ruleData = $this->ruleRegistry->registry(RuleRegistry::RULE_DATA);
        if ($ruleData) {
            try {
                $this->migrateStoreIds($ruleData);
                $this->migrateCustomerGroupIds($ruleData);
                $this->migrateSegmentIds($ruleData);
            } catch (\Exception $e) {
                null;
            }
        }
    }

    public static function getDependencies()
    {
        return [];
    }

    public function getAliases()
    {
        return [];
    }

    private function migrateStoreIds(array $ruleData)
    {
        $relationData = [];

        foreach ($ruleData as $rule) {
            $stores = $rule[CollectRuleData::OLD_STORE_IDS_ALIAS];
            if (!empty($stores)) {
                $storeIds = explode(',', $stores);

                foreach ($storeIds as $storeId) {
                    $relationData[] = [
                        'rule_id' => (int)$rule['rule_id'],
                        'store_id' => (int)$storeId,
                    ];
                }
            }
        }

        if ($relationData) {
            $this->moduleDataSetup->getConnection()->insertMultiple(
                $this->moduleDataSetup->getTable(Rule::RULE_STORE_TABLE),
                $relationData
            );
        }
    }

    private function migrateCustomerGroupIds(array $ruleData)
    {
        $relationData = [];

        foreach ($ruleData as $rule) {
            $customerGroups = $rule[CollectRuleData::OLD_CUSTOMER_GROUP_IDS_ALIAS];
            if (!empty($customerGroups)) {
                $customerGroupIds = explode(',', $customerGroups);

                foreach ($customerGroupIds as $customerGroupId) {
                    $relationData[] = [
                        'rule_id' => (int)$rule['rule_id'],
                        'customer_group_id' => (int)$customerGroupId,
                    ];
                }
            }
        }

        if ($relationData) {
            $this->moduleDataSetup->getConnection()->insertMultiple(
                $this->moduleDataSetup->getTable(Rule::RULE_CUSTOMER_GROUP_TABLE),
                $relationData
            );
        }
    }

    private function migrateSegmentIds(array $ruleData)
    {
        $relationData = [];

        foreach ($ruleData as $rule) {
            $segments = $rule[CollectRuleData::OLD_SEGMENT_IDS_ALIAS];
            if (is_string($segments)) {
                $segmentIds = explode(',', $segments);

                foreach ($segmentIds as $segmentId) {
                    $relationData[] = [
                        'rule_id' => (int)$rule['rule_id'],
                        'segment_id' => (int)$segmentId,
                    ];
                }
            }
        }

        if ($relationData) {
            $this->moduleDataSetup->getConnection()->insertMultiple(
                $this->moduleDataSetup->getTable(Rule::RULE_SEGMENT_TABLE),
                $relationData
            );
        }
    }
}
