<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Follow Up Email for Magento 2
 */

namespace Amasty\Followup\Setup\Patch\Data;

use Amasty\Followup\Helper\Data as DataHelper;
use Magento\Framework\Module\ResourceInterface;
use Magento\Framework\Setup\ModuleDataSetupInterface;
use Magento\Framework\Setup\Patch\DataPatchInterface;

class InstallEmailTemplates implements DataPatchInterface
{
    /**
     * @var DataHelper
     */
    private $helper;

    /**
     * @var ResourceInterface
     */
    private $moduleResource;

    /**
     * @var ModuleDataSetupInterface
     */
    private $moduleDataSetup;

    public function __construct(
        DataHelper $helper,
        ResourceInterface $moduleResource,
        ModuleDataSetupInterface $moduleDataSetup
    ) {
        $this->helper = $helper;
        $this->moduleResource = $moduleResource;
        $this->moduleDataSetup = $moduleDataSetup;
    }

    public function apply()
    {
        // Check if module was already installed or not.
        // If setup_version present in DB then we don't need to install email templates,
        // because setup_version is a marker.
        $setupDataVersion = (string)$this->moduleResource->getDataVersion('Amasty_Followup');
        if (!$setupDataVersion) {
            $this->moduleDataSetup->startSetup();
            $this->createTemplates();
            $this->moduleDataSetup->endSetup();
        }
    }

    public static function getDependencies()
    {
        return [];
    }

    public function getAliases()
    {
        return [];
    }

    private function createTemplates()
    {
        $helper = $this->helper;
        $helper->createTemplate('amfollowup_order_new', 'Amasty Follow Up Email: Order Created');
        $helper->createTemplate('amfollowup_order_ship', 'Amasty Follow Up Email: Order Shipped');
        $helper->createTemplate('amfollowup_order_invoice', 'Amasty Follow Up Email: Order Invoiced');
        $helper->createTemplate('amfollowup_order_complete', 'Amasty Follow Up Email: Order Completed');
        $helper->createTemplate('amfollowup_order_cancel', 'Amasty Follow Up Email: Order Cancelled');
        $helper->createTemplate('amfollowup_customer_group', 'Amasty Follow Up Email: Customer Changed Group');
        $helper->createTemplate('amfollowup_customer_birthday', 'Amasty Follow Up Email: Customer Birthday');
        $helper->createTemplate('amfollowup_customer_new', 'Amasty Follow Up Email: Customer Registration');
        $helper->createTemplate(
            'amfollowup_customer_subscription',
            'Amasty Follow Up Email: Customer Subscribed to Newsletter'
        );
        $helper->createTemplate(
            'amfollowup_customer_activity',
            'Amasty Follow Up Email: Customer No Activity'
        );

        $helper->createTemplate(
            'amfollowup_customer_date',
            'Amasty Follow Up Email: Merry Christmas'
        );

        $helper->createTemplate(
            'amfollowup_customer_wishlist',
            'Amasty Follow Up Email: Customer Wish List Product Added'
        );

        $helper->createTemplate(
            'amfollowup_customer_wishlist_shared',
            'Amasty Follow Up Email: Customer Wish List Shared '
        );

        $helper->createTemplate(
            'amfollowup_customer_wishlist_sale',
            'Amasty Follow Up Email: Customer Wish List on Sale'
        );

        $helper->createTemplate(
            'amfollowup_customer_wishlist_back_instock',
            'Amasty Follow Up Email: Customer Wish List Product Back In Stock'
        );
    }
}
