<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Follow Up Email for Magento 2
 */

namespace Amasty\Followup\Setup\Operation\RuleRelationData;

use Amasty\Followup\Model\ResourceModel\Rule\CollectionFactory;
use Magento\Framework\DB\Select;

class CollectRuleData
{
    public const OLD_STORE_IDS_ALIAS = 'old_store_ids';
    public const OLD_CUSTOMER_GROUP_IDS_ALIAS = 'old_customer_ids';
    public const OLD_SEGMENT_IDS_ALIAS = 'old_segment_ids';

    /**
     * @var CollectionFactory
     */
    private $ruleCollectionFactory;

    /**
     * @var RuleRegistry
     */
    private $ruleRegistry;

    public function __construct(
        CollectionFactory $ruleCollectionFactory,
        RuleRegistry $ruleRegistry
    ) {
        $this->ruleCollectionFactory = $ruleCollectionFactory;
        $this->ruleRegistry = $ruleRegistry;
    }

    public function execute()
    {
        $ruleCollection = $this->ruleCollectionFactory->create();
        $ruleCollection->getSelect()
            ->reset(Select::COLUMNS)
            ->columns([
                'rule_id' => 'rule_id',
                self::OLD_STORE_IDS_ALIAS => 'stores',
                self::OLD_CUSTOMER_GROUP_IDS_ALIAS => 'cust_groups',
                self::OLD_SEGMENT_IDS_ALIAS => 'segments',
            ]);

        $this->ruleRegistry->register(RuleRegistry::RULE_DATA, $ruleCollection->getData());
    }
}
