<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Follow Up Email for Magento 2
 */

namespace Amasty\Followup\Observer;

use Magento\Framework\Event\Observer as EventObserver;
use Magento\Framework\Event\ObserverInterface;
use Amasty\Followup\Model\Rule as Rule;

class WishlistShare implements ObserverInterface
{
    /**
     * @var \Amasty\Followup\Model\ScheduleFactory
     */
    protected $_scheduleFactory;

    /**
     * @var \Magento\Customer\Model\CustomerFactory
     */
    protected $_customerFactory;

    public function __construct(
        \Amasty\Followup\Model\ScheduleFactory $scheduleFactory,
        \Magento\Customer\Model\CustomerFactory $customerFactory
    ) {
        $this->_scheduleFactory = $scheduleFactory;
        $this->_customerFactory = $customerFactory;
    }

    public function execute(EventObserver $observer)
    {
        $wishlist = $observer->getWishlist();
        $customer = $this->_customerFactory->create()->load($wishlist->getCustomerId());

        $this->_scheduleFactory->create()->checkCustomerRules($customer, [
            Rule::TYPE_CUSTOMER_WISHLIST_SHARED
        ]);
    }
}
