<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Follow Up Email for Magento 2
 */

namespace Amasty\Followup\Observer;

use Magento\Framework\Event\Observer as EventObserver;
use Magento\Framework\Event\ObserverInterface;
use Magento\Newsletter\Model\Subscriber;

class NewsletterSubscriberSaveBefore implements ObserverInterface
{
    public const SUBSCRIBER_STATUS_KEY = 'subscriber_status';

    public function execute(EventObserver $observer): void
    {
        $subscriber = $observer->getSubscriber();
        $subscriberStatus = $subscriber->getStoredData()[self::SUBSCRIBER_STATUS_KEY] ?? null;

        NewsletterSubscriber::$isFirstSubscribe = !$subscriber->getId()
            || $subscriberStatus === Subscriber::STATUS_NOT_ACTIVE;
    }
}
