<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Follow Up Email for Magento 2
 */

namespace Amasty\Followup\Observer;

use Amasty\Followup\Model\Rule as Rule;
use Amasty\Followup\Model\ScheduleFactory;
use Magento\Framework\Event\Observer as EventObserver;
use Magento\Framework\Event\ObserverInterface;
use Magento\Framework\Stdlib\DateTime;

class CustomerSaveBefore implements ObserverInterface
{
    /**
     * @var ScheduleFactory
     */
    protected $scheduleFactory;

    /**
     * @var DateTime
     */
    protected $dateTime;

    /**
     * @var bool
     */
    protected $onCustomerChecked = false;

    public function __construct(
        ScheduleFactory $scheduleFactory,
        DateTime $dateTime
    ) {
        $this->scheduleFactory = $scheduleFactory;
        $this->dateTime = $dateTime;
    }

    public function execute(EventObserver $observer)
    {
        $customer = $observer->getCustomer();

        if (!$this->onCustomerChecked) {
            if (!$customer->getCreatedAt()) {
                $customer->setData('created_at', $this->dateTime->formatDate(true));
            }

            $this->scheduleFactory->create()->checkCustomerRules(
                $customer,
                [
                    Rule::TYPE_CUSTOMER_GROUP,
                    Rule::TYPE_CUSTOMER_NEW
                ]
            );
            $this->onCustomerChecked = true;
        }
    }
}
