<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Follow Up Email for Magento 2
 */

namespace Amasty\Followup\Model\Source\System;

use Magento\Framework\Data\OptionSourceInterface;
use Magento\Store\Model\System\Store as SystemStore;

class Website implements OptionSourceInterface
{
    /**
     * @var SystemStore
     */
    private $systemStore;

    public function __construct(
        SystemStore $systemStore
    ) {
        $this->systemStore = $systemStore;
    }

    public function toOptionArray(): array
    {
        return $this->systemStore->getWebsiteValuesForForm();
    }
}
