<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Follow Up Email for Magento 2
 */

namespace Amasty\Followup\Model\Source;

use Magento\Framework\Data\OptionSourceInterface;
use Magento\SalesRule\Model\ResourceModel\Rule\Collection as SalesRuleCollection;
use Magento\SalesRule\Model\ResourceModel\Rule\CollectionFactory as SalesRuleCollectionFactory;

class SalesRules implements OptionSourceInterface
{
    public const MAX_SALES_RULES = 100;

    /**
     * @var SalesRuleCollectionFactory
     */
    private $ruleCollectionFactory;

    /**
     * @var SalesRuleCollection
     */
    private $collection;

    public function __construct(
        SalesRuleCollectionFactory $ruleCollectionFactory
    ) {
        $this->ruleCollectionFactory = $ruleCollectionFactory;
    }

    public function toOptionArray(): array
    {
        $result = [];
        $collection = $this->getSalesRuleCollection();

        foreach ($collection->getItems() as $rule) {
            $result[] = [
                'value' => $rule->getRuleId(),
                'label' => $rule->getName()
            ];
        }

        return $result;
    }

    public function isLessThanLimit(): bool
    {
        $collection = $this->getSalesRuleCollection();

        return $collection->getSize() < self::MAX_SALES_RULES;
    }

    private function getSalesRuleCollection(): SalesRuleCollection
    {
        if (!$this->collection) {
            $this->collection = $this->ruleCollectionFactory->create()
                ->addFilter('use_auto_generation', 1)
                ->addFilter('is_active', 1);
        }

        return $this->collection;
    }
}
