<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Follow Up Email for Magento 2
 */

namespace Amasty\Followup\Model\Source\Rule;

use Amasty\Followup\Model\Rule as Rule;
use Magento\Framework\Data\OptionSourceInterface;

class Status implements OptionSourceInterface
{
    public function toOptionArray(): array
    {
        return [
            [
                'value' => Rule::RULE_ACTIVE,
                'label' => __("Active")
            ],
            [
                'value' => Rule::RULE_INACTIVE,
                'label' => __("Inactive")
            ],
        ];
    }
}
