<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Follow Up Email for Magento 2
 */

namespace Amasty\Followup\Model\Source\Rule;

use Amasty\Followup\Model\Rule as Rule;
use Magento\Framework\Data\OptionSourceInterface;

class StartEventType implements OptionSourceInterface
{
    public function toOptionArray(): array
    {
        return [
            [
                'label' => __('Order'),
                'value' => [
                    ['label' => __('Created'), 'value' => Rule::TYPE_ORDER_NEW],
                    ['label' => __('Shipped'), 'value' => Rule::TYPE_ORDER_SHIP],
                    ['label' => __('Invoiced'), 'value' => Rule::TYPE_ORDER_INVOICE],
                    ['label' => __('Completed'), 'value' => Rule::TYPE_ORDER_COMPLETE],
                    ['label' => __('Cancelled'), 'value' => Rule::TYPE_ORDER_CANCEL],
                ]
            ],
            [
                'label' => __('Customer'),
                'value' => [
                    ['label' => __('No Activity'), 'value' => Rule::TYPE_CUSTOMER_ACTIVITY],
                    ['label' => __('Changed Group'), 'value' => Rule::TYPE_CUSTOMER_GROUP],
                    ['label' => __('Subscribed to Newsletter'), 'value' => Rule::TYPE_CUSTOMER_SUBSCRIPTION],
                    ['label' => __('Birthday'), 'value' => Rule::TYPE_CUSTOMER_BIRTHDAY],
                    ['label' => __('Registration'), 'value' => Rule::TYPE_CUSTOMER_NEW],
                ]
            ],
            [
                'label' => __('Wishlist'),
                'value' => [
                    ['label' => __('Product Added'), 'value' => Rule::TYPE_CUSTOMER_WISHLIST],
                    ['label' => __('Shared'), 'value' => Rule::TYPE_CUSTOMER_WISHLIST_SHARED],
                    ['label' => __('Wishlist on sale'), 'value' => Rule::TYPE_CUSTOMER_WISHLIST_SALE],
                    ['label' => __('Wishlist back in stock'), 'value' => Rule::TYPE_CUSTOMER_WISHLIST_BACK_INSTOCK],
                ]
            ],
            [
                'label' => __('Date'),
                'value' => [
                    ['label' => __('Date'), 'value' => Rule::TYPE_CUSTOMER_DATE]
                ]
            ]
        ];
    }

    public function isOrderRelated(string $type): bool
    {
        return in_array(
            $type,
            [
                Rule::TYPE_ORDER_NEW,
                Rule::TYPE_ORDER_SHIP,
                Rule::TYPE_ORDER_INVOICE,
                Rule::TYPE_ORDER_COMPLETE,
                Rule::TYPE_ORDER_CANCEL,
            ]
        );
    }

    public function isWishlistRelated(string $type): bool
    {
        return in_array(
            $type,
            [
                Rule::TYPE_CUSTOMER_WISHLIST,
                Rule::TYPE_CUSTOMER_WISHLIST_SHARED,
                Rule::TYPE_CUSTOMER_WISHLIST_SALE,
                Rule::TYPE_CUSTOMER_WISHLIST_BACK_INSTOCK,
            ]
        );
    }
}
