<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Follow Up Email for Magento 2
 */

namespace Amasty\Followup\Model\Source\Rule;

use Amasty\Followup\Model\Factories\SegmentFactory;
use Amasty\Followup\Model\ThirdParty\ModuleChecker;
use Magento\Framework\Data\OptionSourceInterface;

class Segments implements OptionSourceInterface
{
    /**
     * @var SegmentFactory
     */
    private $segmentFactory;

    /**
     * @var ModuleChecker
     */
    private $moduleChecker;

    public function __construct(
        SegmentFactory $segmentFactory,
        ModuleChecker $moduleChecker
    ) {
        $this->segmentFactory = $segmentFactory;
        $this->moduleChecker = $moduleChecker;
    }

    public function toOptionArray(): array
    {
        $options = [];
        if ($this->moduleChecker->isAmastySegmentEnabled()) {
            $segmentCollection = $this->segmentFactory->getSegmentCollection();
            $options = $segmentCollection->toOptionArray();
        }

        return $options;
    }
}
