<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Follow Up Email for Magento 2
 */

namespace Amasty\Followup\Model\Source\Rule;

use Amasty\Followup\Model\Rule;
use Magento\Email\Model\ResourceModel\Template\CollectionFactory as TemplatesCollectionFactory;
use Magento\Framework\Data\OptionSourceInterface;

class EmailTemplates implements OptionSourceInterface
{
    /**
     * @var TemplatesCollectionFactory
     */
    private $templatesCollectionFactory;

    public function __construct(
        TemplatesCollectionFactory $templatesCollectionFactory
    ) {
        $this->templatesCollectionFactory = $templatesCollectionFactory;
    }

    public function toOptionArray(): array
    {
        $collection = $this->templatesCollectionFactory->create()
            ->addFilter('orig_template_code', '%amfollowup_%');

        return $collection->toOptionArray();
    }

    public function getByType(string $type): array
    {
        $collection = $this->templatesCollectionFactory->create()
            ->addFieldToFilter(
                'orig_template_code',
                [
                    'like' => '%amfollowup_' . $type . '%'
                ]
            );

        if ($type == Rule::TYPE_CUSTOMER_WISHLIST) {
            $collection->addFieldToFilter(
                'orig_template_code',
                ['nlike' => '%amfollowup_' . $type . '_shared%']
            )->addFieldToFilter(
                'orig_template_code',
                ['nlike' => '%amfollowup_' . $type . '_sale%']
            )->addFieldToFilter(
                'orig_template_code',
                ['nlike' => '%amfollowup_' . $type . '_back_instock%']
            );
        }

        return $collection->toOptionArray();
    }
}
