<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Follow Up Email for Magento 2
 */

namespace Amasty\Followup\Model\Source;

use Amasty\Followup\Model\ResourceModel\BlacklistFactory;
use Magento\Framework\App\Filesystem\DirectoryList;
use Magento\Framework\Filesystem;

class Import extends \Magento\Config\Model\Config\Backend\File
{
    /**
     * @var BlacklistFactory
     */
    protected $_blacklistFactory;

    public function __construct(
        \Magento\Framework\Model\Context $context,
        \Magento\Framework\Registry $registry,
        \Magento\Framework\App\Config\ScopeConfigInterface $config,
        \Magento\Framework\App\Cache\TypeListInterface $cacheTypeList,
        \Magento\MediaStorage\Model\File\UploaderFactory $uploaderFactory,
        \Magento\Config\Model\Config\Backend\File\RequestData\RequestDataInterface $requestData,
        Filesystem $filesystem,
        BlacklistFactory $blacklistFactory,
        \Magento\Framework\Model\ResourceModel\AbstractResource $resource = null,
        \Magento\Framework\Data\Collection\AbstractDb $resourceCollection = null,
        array $data = []
    ) {
        $this->_blacklistFactory = $blacklistFactory;

        return parent::__construct(
            $context,
            $registry,
            $config,
            $cacheTypeList,
            $uploaderFactory,
            $requestData,
            $filesystem,
            $resource,
            $resourceCollection,
            $data
        );
    }

    public function beforeSave()
    {
        return $this;
    }

    public function save()
    {
        $tmpName = $this->_requestData->getTmpName($this->getPath());

        $directory = $this->_filesystem->getDirectoryRead(DirectoryList::SYS_TMP);

        $file = $directory->openFile($directory->getRelativePath($tmpName), 'r');

        $emails = [];

        while (($csvLine = $file->readCsv()) !== false) {
            foreach ($csvLine as $email) {
                if (!empty($email)
                    && filter_var($email, FILTER_VALIDATE_EMAIL) !== false
                ) {
                    $emails[]['email'] = $email;
                }
            }
        }

        if (!empty($emails)) {
            $this->_blacklistFactory->create()
                ->saveImportData($emails);
        }

        return $this;
    }

    protected function _getAllowedExtensions()
    {
        return ['csv', 'txt'];
    }
}
