<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Follow Up Email for Magento 2
 */

namespace Amasty\Followup\Model\Rule;

use Amasty\Followup\Controller\RegistryConstants;
use Amasty\Followup\Model\Rule;
use Magento\Framework\Registry;

class Locator
{
    /**
     * @var Registry
     */
    private $coreRegistry;

    public function __construct(Registry $coreRegistry)
    {
        $this->coreRegistry = $coreRegistry;
    }

    public function getRule(): Rule
    {
        return $this->coreRegistry->registry(RegistryConstants::CURRENT_AMASTY_AMFOLLOWUP_RULE);
    }
}
