<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Follow Up Email for Magento 2
 */

namespace Amasty\Followup\Model\ResourceModel;

use Amasty\Followup\Api\Data\RuleInterface;
use Amasty\Followup\Model\ResourceModel\Rule as ResourceRule;
use Magento\Framework\Model\ResourceModel\Db\AbstractDb;

/**
 * Statistics Resource Model used for statistics and based on amasty_amfollowup_rule,
 * because now statistics are collected according to the rules.
 * In the future we can improve the statistics and change the main table if necessary.
 */
class Statistics extends AbstractDb
{
    protected function _construct()
    {
        $this->_init(ResourceRule::RULE_TABLE, RuleInterface::RULE_ID);
    }
}
