<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package Follow Up Email for Magento 2
 */

namespace Amasty\Followup\Model\ResourceModel\Rule\Relation\Store;

use Amasty\Followup\Api\Data\RuleInterface;
use Amasty\Followup\Model\ResourceModel\Rule;
use Amasty\Followup\Model\ResourceModel\Rule\Relation\HandlerInterface;
use Magento\Framework\App\ResourceConnection;
use Magento\Framework\DB\Adapter\AdapterInterface;

class SaveHandler implements HandlerInterface
{
    /**
     * @var ResourceConnection
     */
    private $resourceConnection;

    /**
     * @var string
     */
    private $ruleStoreTable;

    public function __construct(
        ResourceConnection $resourceConnection
    ) {
        $this->resourceConnection = $resourceConnection;
        $this->ruleStoreTable = $this->resourceConnection->getTableName(Rule::RULE_STORE_TABLE);
    }

    public function execute(RuleInterface $entity, array $arguments = []): RuleInterface
    {
        $entityId = $entity->getRuleId();
        if (!$entityId) {
            return $entity;
        }

        $this->deleteByEntity($entityId);
        $storeIdsToInsert = $this->getStoreIds($entity);
        $this->insertStoreData($storeIdsToInsert);

        return $entity;
    }

    private function getConnection(): AdapterInterface
    {
        return $this->resourceConnection->getConnection();
    }

    private function deleteByEntity(int $ruleId): void
    {
        $this->getConnection()->delete($this->ruleStoreTable, [RuleInterface::RULE_ID . ' = ?' => $ruleId]);
    }

    private function getStoreIds(RuleInterface $entity): array
    {
        $ruleStoreIds = [];

        if ($storeIds = $entity->getStoreIds()) {
            foreach ($storeIds as $storeId) {
                $ruleStoreIds[] = [
                    'rule_id' => $entity->getRuleId(),
                    'store_id' => $storeId
                ];
            }
        }

        return $ruleStoreIds;
    }

    private function insertStoreData(array $storeIdsToInsert)
    {
        if (!empty($storeIdsToInsert)) {
            $this->getConnection()->insertMultiple($this->ruleStoreTable, $storeIdsToInsert);
        }

        return $this;
    }
}
